const express = require("express");
const multer = require("multer");
const fs = require("fs");
const { authenticateToken } = require("../middleware/authMiddleware");
const { 
    addEvent, getEvents, updateEvent, deleteEvent, getEventBySlug, addEventPost, 
    getEventPosts, getApprovedEventPosts, getVideoId, updateVideoWebhook, getAllEventPosts, 
    updateEventPostFavourite, updateEventPostStatus } = require("../controllers/eventController");
const router = express.Router();


// Set up multer storage configuration
const storage = multer.diskStorage({
  destination: function (req, file, cb) {
    
    const userId = req.body.user_id || '1'; // Get user ID from request body or token
    const event_id = req.body.event_id || ''; // Get event ID if available
    
    let uploadPath = `./uploads/`;
    if (event_id) {
      uploadPath += `events/event_id_${event_id}`;
    } else {
      uploadPath += `users/user_id_${userId}`;
    }

    // Create directory if it doesn't exist
    fs.mkdirSync(uploadPath, { recursive: true });

    cb(null, uploadPath);
  },
  filename: function (req, file, cb) {
    const uniqueSuffix = Date.now() + "-" + Math.round(Math.random() * 1e9);
    cb(null, uniqueSuffix + "-" + file.originalname); // Save the file with a unique name
  },
});

const upload = multer({ storage: storage });

// Route to fetch all events
router.get("/get-events", authenticateToken, getEvents); // New route for fetching events

// Route to add a new event
// router.post("/add-event", addEvent); 
router.post("/add-event", authenticateToken, upload.fields([
  { name: 'brand_custom_logo', maxCount: 1 },
  { name: 'brand_social_share_image', maxCount: 1 },
  { name: 'brand_watermark_image', maxCount: 1 }]), addEvent);

// Route to update a event by its ID
// router.put("/update-event/:id", updateEvent);

// Route to update an event by its ID
router.put("/update-event/:id", authenticateToken, upload.fields([
  { name: 'brand_custom_logo', maxCount: 1 },
  { name: 'brand_social_share_image', maxCount: 1 },
  { name: 'brand_watermark_image', maxCount: 1 }
]), updateEvent);

// Route to delete an existing script by its ID
router.delete("/delete-event/:id", authenticateToken, deleteEvent);

// Route to fetch all events
router.get("/get-event-posts/:event_id", getEventPosts); // New route for fetching events

// Route to fetch all events posts
router.get("/get-all-event-posts", getAllEventPosts); // New route for fetching events

// Route to get event by URL slug
router.post('/update-video-webhook', updateVideoWebhook);

// Your existing routes
router.put('/update-event-post-favourite/:post_id', updateEventPostFavourite);

// Route to update the status of a post
router.put('/update-event-post-status/:post_id', updateEventPostStatus);


// Public routes - No need of authentication ----------

// Route to get event by URL slug
router.get('/event-by-slug/:eventUrlSlug', getEventBySlug);

// Route to fetch approved-event-posts
router.get("/get-approved-event-posts/:event_id", getApprovedEventPosts); // New route for fetching events

// POST route for creating an event post
router.post('/add-event-post', upload.fields([
  { name: 'media', maxCount: 1 },
]), addEventPost);

// Route to get event by URL slug
router.get('/get-video-id/', getVideoId);



module.exports = router;
