const express = require("express");

const { authenticateToken } = require("../middleware/authMiddleware");
const { getEventAdsGroups, getAdsByGroupId, addEventAdsGroup, updateEventAdsGroup, deleteEventAdsGroup} = require("../controllers/adGroupController");
    
const router = express.Router();

// Route to fetch all events
router.get("/get-event-ads-groups", authenticateToken, getEventAdsGroups); // New route for fetching events

// POST route for creating an event post
router.post("/add-event-ads-group", authenticateToken, addEventAdsGroup);

// Route to update an event by its ID
router.put("/update-event-ads-group/:id", authenticateToken, updateEventAdsGroup);

// Route to delete an existing script by its ID
router.delete("/delete-event-ads-group/:id", authenticateToken, deleteEventAdsGroup);

// Public routes - No need of authentication ----------

// Route to fetch all events
router.get("/get-ads-by-group-id", getAdsByGroupId); // New route for fetching events


module.exports = router;
