const express = require("express");
const router = express.Router();

// Endpoint to update video for a specific pairing ID
router.post('/update-video/:pairingId', (req, res) => {
    const { pairingId } = req.params;
    const videoUrl = req.body.videoUrl;

    if (!videoUrl) {
        return res.status(400).send('Video URL is required');
    }

    if (clients[pairingId]) {
        clients[pairingId].emit('videoUpdated', { videoUrl });
        console.log(`Video updated for pairing ID: ${pairingId}, URL: ${videoUrl}`);
        res.sendStatus(200);
    } else {
        res.status(404).send('Pairing ID not found');
    }
});

// New endpoint to update orientation for a specific pairing ID
router.post('/update-orientation/:pairingId', (req, res) => {
    const { pairingId } = req.params;
    const { orientation } = req.body; // Expected values: 'landscape' or 'portrait'

    if (!orientation || !['landscape', 'portrait'].includes(orientation)) {
        return res.status(400).send('Valid orientation (landscape or portrait) is required');
    }

    if (clients[pairingId]) {
        clients[pairingId].emit('orientationUpdated', { orientation });
        console.log(`Orientation updated for pairing ID: ${pairingId}, Orientation: ${orientation}`);
        res.sendStatus(200);
    } else {
        res.status(404).send('Pairing ID not found');
    }
});

module.exports = router;
